<?php
defined('PF_VERSION') OR exit('Access denied');
$action = (! empty ( $_GET ['action'] ) && in_array ( $_GET ['action'], array (
        'add',
        'edit',
        'delete',
        'index',
        'setting-form'
) )) ? $_GET ['action'] : 'index';
$theme =  get_option('active_theme');
$path_theme_widget = sprintf(WIDGET_PATH,$theme);
switch ($action) {
    case 'add' :
        $type = (! empty ( $_GET ['type'] ) && in_array ( $_GET ['type'], array (
                'pattern',
                'builder',
                'save' 
        ) )) ? $_GET ['type'] : 'pattern';
        switch ($type) {
            case 'pattern' :
                
                require abs_plugin_path(__FILE__) . '/theme/layouts/templates/add-' . $type . '.php';
                break;
            case 'builder' :
                $error = array();
                $widgets = get_widgtes($path_theme_widget);
                $active_widgets = get_option ( 'active_widgets' );
                if (!is_array($widgets)){
                    $widgets = array();
                }
                if (!is_array($active_widgets)){
                    $active_widgets = array();
                }
                
                require abs_plugin_path(__FILE__) . '/theme/layouts/templates/add-' . $type . '.php';
                break;
            case 'save' :
                $validate_rules = array('layout_name' => 'required');
                $validate_filters = array(
                        'layout_name' => 'trim'
                );
                $validator = Pf::validator();
                $_POST = $validator->filter($_POST, $validate_filters);
                $validated = $validator->validate(
                        $_POST, $validate_rules
                );
                if ($validated === true){
                    $layout = array ();
                    $layout ['layout_name'] = $_POST ['layout_name'];
                    $layout ['pattern'] = $_POST ['pattern'];
                    $layout ['json_data'] = $_POST ['json_data'];
                    $layout ['setting_data'] = json_decode($_POST ['setting_data'],true);
                    
                    $layouts = get_option ( 'layouts' );
                    
                    if ($layouts == null) {
                        $layouts = array ();
                    }
                    if (empty ( $_POST ['id'] )) {
                        $layout ['id'] = uniqid ();
                        $layouts [] = $layout;
                    } else {
                        $layout ['id'] = $_POST ['id'];
                        if (! empty ( $layouts )) {
                            foreach ( $layouts as $k => $v ) {
                                if ($layout ['id'] == $v ['id']) {
                                    $layouts [$k] = $layout;
                                    break;
                                }
                            }
                        }
                    }
                    
                    update_option ( 'layouts', $layouts );
                    $_SESSION['success']    =   __('Layout is updated successfully','theme');
                    header ( "Location: " . admin_url ( 'action=&type=&id=' ) );
                }else{
                    $error = $validator->get_readable_errors(false);
                    $widgets = get_widgtes($path_theme_widget);
                    $active_widgets = get_option ( 'active_widgets' );
                    if (!is_array($widgets)){
                        $widgets = array();
                    }
                    if (!is_array($active_widgets)){
                        $active_widgets = array();
                    }
                    if (empty ( $_POST ['id'] )) {
                        require abs_plugin_path(__FILE__) . '/theme/layouts/templates/add-builder.php';
                    }else{
                        require abs_plugin_path(__FILE__) . '/theme/layouts/templates/edit-builder.php';
                    }
                }
                break;
        }
        
        break;
    case 'edit' :
        $error = array();
        $widgets = get_widgtes($path_theme_widget);
        $active_widgets = get_option ( 'active_widgets' );
        if (!is_array($widgets)){
            $widgets = array();
        }
        if (!is_array($active_widgets)){
            $active_widgets = array();
        }
        require abs_plugin_path(__FILE__) . '/theme/layouts/templates/edit-builder.php';
        break;
    case 'delete' :
        if (! empty ( $_GET ['id'] )) {
            $layouts = get_option ( 'layouts' );
            if (! empty ( $layouts )) {
                foreach ( $layouts as $k => $v ) {
                    if ($_GET ['id'] == $v ['id']) {
                        unset ( $layouts [$k] );
                        break;
                    }
                }
                update_option ( 'layouts', $layouts );
            }
        }
        
        header ( "Location: " . admin_url ( 'action=&id=' ) );
        break;
    case 'setting-form':
        if (is_ajax()){
            $widget = $_POST['widget'];
            if (!empty($_POST['data'])){
                $_POST = $_POST['data'];
            }
            if (!empty($widget['id'])){
                $widget_id = str_replace('widget_', '', strtolower($widget['id']));
                $widget_class = ucfirst($widget_id).'_Widget';
            
                if (!class_exists($widget_class)){
                    if (is_file($path_theme_widget.'/'.$widget_id.'/'.$widget_id.'.php')){
                        require $path_theme_widget.'/'.$widget_id.'/'.$widget_id.'.php';
                    }else{
                        // Error: Widget class is not found.
                    }
                }
            
                if (class_exists($widget_class) && get_parent_class($widget_class) == 'Pf_Widget'){
                    $widget_object = new $widget_class($widget,array());
                    if (method_exists($widget_object, 'setting_form')){
                        $widget_object->setting_form();
                    }else{
                        // Error: Widget main method is not found.
                    }
                }else{
                    // Error: Widget class must extend Pf_Widget .
                }
            }else{
                // Error: Widget don't have the id.
            }
        }
        break;
    case 'index' :
        $page = (! empty ( $_GET ['page'] )) ? $_GET ['page'] : '1';
        $pf_search = (! empty ( $_REQUEST ['pf_search'] )) ? $_REQUEST ['pf_search'] : '';
        
        $layouts = get_option ( 'layouts' );
        
        if (empty($layouts) || !is_array($layouts)){
            $layouts = array();
        }
        
        if (! empty ( $pf_search )) {
            $layouts = array_filter ( $layouts, 'search_layout_callback' );
        }
        
        $total = count ( $layouts );
        $total_page = ceil ( $total / NUM_PER_PAGE );
        if ($page > $total_page) {
            $_GET ['page'] = $page = $total_page;
        }
        $start = ($page - 1) * NUM_PER_PAGE;
        $layouts = array_slice ( $layouts, $start, NUM_PER_PAGE );
        $pages = new PF_Paginator ( $total, NUM_PER_PAGE, 'page' );
        require abs_plugin_path(__FILE__) . '/theme/layouts/templates/index.php';
        break;
}
function search_layout_callback($layout) {
    $term = trim ( $_REQUEST ['pf_search'] );
    if (stripos ( $layout ['layout_name'], $term ) !== false)
        return true;
    
    return false;
}